(function () {
    let app = angular.module('ui', ['contractRequest', 'notifications']);

    app.directive('ui', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/ui.html',
            controller: function ($rootScope, $scope, $timeout) {
                let ctrl = this;
                $scope.showItemList = false;
                $scope.GetLocalized = Helpers.GetLocalized;

                Helpers.MovePropToIsolatedScope($rootScope, $scope, 'settings');

                Helpers.RootScopeWatchAndDestroy($scope, 'settings.date', date => {
                    if (date == null) return;

                    ctrl.daysPlayed = GetDateDiffInDays(date);
                    $rootScope.daysPlayed = ctrl.daysPlayed;
                    ctrl.formattedTime = moment(new Date(date)).format('HH:mm');
                });

                Helpers.RootScopeWatchAndDestroy($scope, 'settings.mails', mails => {
                    if (mails == null) return;
                    ctrl.unreadMails = mails.filter(x => !x.read).length;
                }, true);

                Helpers.RootScopeWatchAndDestroy($scope, 'settings.contracts', contracts => {
                    if (contracts == null) return;
                    ctrl.availableContracts = contracts.filter(x => !x.completed).length;
                }, true);

                ctrl.zoomLevels = [
                    {title: '25%', value: 0},
                    {title: '50%', value: 1},
                    {title: '100%', value: 2},
                ];

                ctrl.jumpToNextMorning = () => {
                    let now = moment($rootScope.settings.date);
                    let startTimes = Game.Lifecycle.EmployeeStats
                        .filter(employeeStat =>
                            ![Enums.EmployeeStates.OnVacation, Enums.EmployeeStates.Sick, Enums.EmployeeStates.SentHome].includes(employeeStat.employeeState)
                        )
                        .map(x => x.employee)
                        .map(x => x.workingHours)
                        .map(x => {
                            let result = moment(now);
                            result.hour(x.start.hour);
                            result.minute(x.start.minute);
                            return result;
                        });

                    let earliestStartTime = startTimes.sort()[0];
                    if (startTimes.length == 0) {
                        earliestStartTime = moment(now).hour(8).minute(0);
                    }

                    if (now.hours() >= earliestStartTime.hours())
                        earliestStartTime.add(1, 'days');

                    let darkOverlay = $('dark-overlay');
                    darkOverlay.fadeIn();
                    $timeout(() => {
                        // Run time forward, one minute at a time
                        while (now.diff(earliestStartTime) < 0) {
                            now.add(1, 'minute');
                            Game.Lifecycle._update(1, true);
                        }
                        Game.Lifecycle._update(1);
                        darkOverlay.fadeOut();
                    }, 500);
                };

                ctrl.changeZoom = zoomLevel => {
                    $rootScope.options.zoomLevel = zoomLevel;
                    $rootScope.saveOptions();
                    SetZoom();
                };

                ctrl.moddingDirectives = Modding.directives.map(x => { return { name: x }});
            },
            controllerAs: 'ctrl'
        };
    });

    app.directive("render", function($compile){
        return {
            restrict: 'E',
            scope: {
                template: '='
            },
            link: function(scope, element) {
                let template = `<${scope.template} ng-if="$root.view == '${scope.template}'" class="dialog"></${scope.template}>`;
                let directiveElement = $compile(template)(scope);
                element.parent().append(directiveElement);
                element.remove();
            }
        }
    });
})();
